package ru.yandex.direct.ess.config.moderation.asset;

import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.common.models.EssGroup;
import ru.yandex.direct.ess.common.models.EssGroups;
import ru.yandex.direct.ess.config.moderation.BaseModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.asset.BannerAssetModerationEventsObject;

@EssGroups({EssGroup.MODERATION, EssGroup.BANNER_MODERATION})
public class BannerVcardModerationConfig extends BaseModerationConfig {

    private static final String TOPIC_NAME = "ess--asset-moderation-vcard";
    private static final String MODERATION_PROCESS_NAME = "asset_vcard";

    @Override
    public String getTopic() {
        return TOPIC_NAME;
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return BannerAssetModerationEventsObject.class;
    }

    @Override
    public String getModerationProcessName() {
        return MODERATION_PROCESS_NAME;
    }
}
