package ru.yandex.direct.ess.config.moderation.banner;

import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.common.models.EssGroup;
import ru.yandex.direct.ess.common.models.EssGroups;
import ru.yandex.direct.ess.config.moderation.BaseModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.bannerstorage.BannerstorageCreativeModerationEventsObject;

@EssGroups({EssGroup.MODERATION, EssGroup.BANNER_MODERATION})
public class BannerstorageCreativeModerationConfig extends BaseModerationConfig {
    private static final String TOPIC_NAME = "ess--bannerstorage-creatives-moderation";
    private static final String LOGIC_PROCESS_NAME = "bannerstorage_creatives_moderation";

    @Override
    public String getTopic() {
        return TOPIC_NAME;
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return BannerstorageCreativeModerationEventsObject.class;
    }

    @Override
    public String getModerationProcessName() {
        return LOGIC_PROCESS_NAME;
    }

    @Override
    public int getRowsThreshold() {
        // Дефолт в 10,000 тут не подойдёт, т.к. для каждого креатива нужны будут действия
        // вида "сходить в ручку bannerstorage, сходить в базу". Если на вход поступит пачка в 10,000
        // объектов, мы просто не уложимся в разумное время. С другой стороны, поток креативов из bannerstorage
        // не очень большой, поэтому хватит и небольшого размера пачки
        return 20;
    }
}
