package ru.yandex.direct.ess.config.moderation.banner;

import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.common.models.EssGroup;
import ru.yandex.direct.ess.common.models.EssGroups;
import ru.yandex.direct.ess.config.moderation.BaseModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.banner.BannerModerationEventsObject;

@EssGroups({EssGroup.MODERATION, EssGroup.BANNER_MODERATION})
public abstract class BaseBannerModerationConfig extends BaseModerationConfig {

    static final String TOPIC_TEMPLATE = "%s-%s";
    static final String LOGIC_PROCESS_NAME_TEMPLATE = "%s_%s";

    static final String TOPIC_PREFIX = "ess--banner-moderation";
    static final String LOGIC_PROCESS_NAME_PREFIX = "banner_moderation";

    protected abstract BannersBannerType getBannerType();

    private String getBannerTypeLiteral() {
        return getBannerType().getLiteral();
    }

    @Override
    public String getTopic() {
        return String.format(TOPIC_TEMPLATE, TOPIC_PREFIX, getBannerTypeLiteral());
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return BannerModerationEventsObject.class;
    }

    @Override
    public String getModerationProcessName() {
        return String.format(LOGIC_PROCESS_NAME_TEMPLATE, LOGIC_PROCESS_NAME_PREFIX, getBannerTypeLiteral());
    }
}
