package ru.yandex.direct.ess.config.moderation.banner;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;

@ParametersAreNonnullByDefault
public class InternalBannerModerationConfig extends BaseBannerModerationConfig {

    private static final String TOPIC_NAME = "internal_banner";

    @Override
    protected BannersBannerType getBannerType() {
        return BannersBannerType.internal;
    }

    @Override
    public String getTopic() {
        return String.format(TOPIC_TEMPLATE, TOPIC_PREFIX, TOPIC_NAME);
    }

    @Override
    public String getModerationProcessName() {
        return String.format(LOGIC_PROCESS_NAME_TEMPLATE, LOGIC_PROCESS_NAME_PREFIX, TOPIC_NAME);
    }

}
