package ru.yandex.direct.ess.config.moderation.banner;

import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.common.models.EssGroup;
import ru.yandex.direct.ess.common.models.EssGroups;
import ru.yandex.direct.ess.config.moderation.BaseModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.sitelinks.SitelinksModerationEventsObject;

@EssGroups({EssGroup.MODERATION, EssGroup.BANNER_MODERATION})
public class SitelinksModerationConfig extends BaseModerationConfig {

    private static final String TOPIC_NAME = "ess--sitelinks-moderation";
    private static final String LOGIC_PROCESS_NAME = "sitelinks_moderation";

    @Override
    public String getTopic() {
        return TOPIC_NAME;
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return SitelinksModerationEventsObject.class;
    }

    @Override
    public String getModerationProcessName() {
        return LOGIC_PROCESS_NAME;
    }

}
