package ru.yandex.direct.ess.config.moderation.banner;

import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.common.models.EssGroup;
import ru.yandex.direct.ess.common.models.EssGroups;
import ru.yandex.direct.ess.config.moderation.BaseModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.turbolandings.TurbolandingsModerationEventsObject;

@EssGroups({EssGroup.MODERATION, EssGroup.BANNER_MODERATION})
public class TurbolandingsModerationConfig extends BaseModerationConfig {

    private static final String TOPIC_NAME = "ess--turbolandings-moderation";
    private static final String LOGIC_PROCESS_NAME = "turbolandings_moderation";

    @Override
    public String getTopic() {
        return TOPIC_NAME;
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return TurbolandingsModerationEventsObject.class;
    }

    @Override
    public String getModerationProcessName() {
        return LOGIC_PROCESS_NAME;
    }

}
