package ru.yandex.direct.ess.config.moderation.contentpromotion;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.config.moderation.BaseModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.contentpromotion.ContentPromotionAccessibilityLogicObject;

@ParametersAreNonnullByDefault
public class ContentPromotionAccessibilityConfig extends BaseModerationConfig {

    @Override
    public String getTopic() {
        return "ess--content-promotion-is-inaccessible";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return ContentPromotionAccessibilityLogicObject.class;
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(1);
    }

    @Override
    public String getModerationProcessName() {
        return "content_promotion_is_inaccessible";
    }
}
