package ru.yandex.direct.ess.config.moderation.special;

import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.common.models.EssGroup;
import ru.yandex.direct.ess.common.models.EssGroups;
import ru.yandex.direct.ess.config.moderation.BaseModerationConfig;
import ru.yandex.direct.ess.logicobjects.moderation.special.ModerationDeletionEvent;

@EssGroups({EssGroup.MODERATION})
public class ModerationDeletionConfig extends BaseModerationConfig {

    @Override
    public String getTopic() {
        return "ess--moderation-special-deletion";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return ModerationDeletionEvent.class;
    }

    @Override
    public String getModerationProcessName() {
        return "moderation-special-deletion";
    }
}
