package ru.yandex.direct.ess.config.mysql2grut

import java.time.Duration
import ru.yandex.direct.ess.common.models.BaseEssConfig
import ru.yandex.direct.ess.logicobjects.mysql2grut.Mysql2GrutReplicationObject

class Mysql2GrutReplicationConfig : BaseEssConfig() {
    override fun getTopic() = "ess--mysql2grut-replication"

    override fun getLogicObject() = Mysql2GrutReplicationObject::class.java

    override fun getRowsThreshold() = 20000

    override fun getTimeToReadThreshold() = Duration.ofSeconds(2)!!

    override fun getCriticalEssProcessTime() = Duration.ofMinutes(20)!!

    override fun getLogicProcessName() = "mysql_to_grut_replication"

    override fun processReshardingEvents() = false
}
