package ru.yandex.direct.ess.config.promocodescheckcampaignchanges;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.promocodescheckcampaignchanges.PromocodesCheckCampaignChangesObject;

public class PromocodesCheckCampaignChangesConfig extends BaseEssConfig {

    private static final String LOGIC_PROCESS_NAME = "promocodes_check_campaign_changes";

    @Override
    public String getTopic() {
        return "ess--promocodes-check-campaign-changes";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return PromocodesCheckCampaignChangesObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return 5_000;
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return Duration.ofSeconds(30);
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(20);
    }

    @Override
    public String getLogicProcessName() {
        return LOGIC_PROCESS_NAME;
    }

    @Override
    public boolean processReshardingEvents() {
        return false;
    }
}
