package ru.yandex.direct.ess.config.recomtracer;

import java.time.Duration;

import ru.yandex.direct.ess.common.models.BaseEssConfig;
import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.logicobjects.recomtracer.RecomTracerLogicObject;

public class RecomTracerConfig extends BaseEssConfig {

    private static final String LOGIC_PROCESS_NAME = "recom_tracer";

    @Override
    public String getTopic() {
        return "ess--recom-tracer";
    }

    @Override
    public Class<? extends BaseLogicObject> getLogicObject() {
        return RecomTracerLogicObject.class;
    }

    @Override
    public int getRowsThreshold() {
        return 5_000;
    }

    @Override
    public Duration getTimeToReadThreshold() {
        return Duration.ofSeconds(2);
    }

    @Override
    public Duration getCriticalEssProcessTime() {
        return Duration.ofMinutes(40);
    }

    @Override
    public String getLogicProcessName() {
        return LOGIC_PROCESS_NAME;
    }

    @Override
    public boolean processReshardingEvents() {
        return false;
    }
}
