package ru.yandex.direct.ess.config.uac.updatestatuses

import java.time.Duration
import ru.yandex.direct.ess.common.models.BaseEssConfig
import ru.yandex.direct.ess.logicobjects.uac.updatestatuses.UacUpdateStatusesObject

class UacUpdateStatusesConfig : BaseEssConfig() {
    override fun getTopic() = "ess--uac-update-statuses"

    override fun getLogicObject() = UacUpdateStatusesObject::class.java

    override fun getRowsThreshold() = 5_000


    override fun getTimeToReadThreshold() = getDefaultTimeToReadThreshold()!!

    override fun getCriticalEssProcessTime() = Duration.ofMinutes(10)!!

    override fun getLogicProcessName() = "uac_update_statuses"

    override fun processReshardingEvents() = false
}
