package ru.yandex.direct.ess.config.userblock

import ru.yandex.direct.ess.common.models.BaseEssConfig
import ru.yandex.direct.ess.common.models.BaseLogicObject
import ru.yandex.direct.ess.logicobjects.userblock.UserBlockObject
import java.time.Duration

class UserBlockConfig : BaseEssConfig() {
    override fun getTopic(): String {
        return "ess--user-block"
    }

    override fun getLogicObject(): Class<out BaseLogicObject?> {
        return UserBlockObject::class.java
    }

    override fun getRowsThreshold(): Int {
        return 50_000
    }

    override fun getTimeToReadThreshold(): Duration {
        return getDefaultTimeToReadThreshold()
    }

    override fun getCriticalEssProcessTime(): Duration {
        return Duration.ofMinutes(10)
    }

    override fun getLogicProcessName(): String {
        return LOGIC_PROCESS_NAME
    }

    override fun processReshardingEvents(): Boolean {
        return false
    }

    companion object {
        private const val LOGIC_PROCESS_NAME = "user_block"
    }
}
