package ru.yandex.direct.ess.logicobjects.aggregatedstatuses;

import java.util.Objects;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.direct.aggregatedstatuses.AggregatedStatusObjectType;
import ru.yandex.direct.ess.common.models.BaseLogicObject;

public class AggregatedStatusEventObject extends BaseLogicObject {
    @JsonProperty("type")
    private final AggregatedStatusObjectType type;

    @JsonProperty("id")
    private final Long id;

    @JsonProperty("parent_id")
    private final Long parentId;

    @JsonProperty("cid")
    private final Long campaignId; // for index purposes, you can't select bids_arc without it

    @JsonProperty("deleted")
    private final boolean deleted;

    @JsonProperty("from_grut")
    private final Boolean fromGrut;

    @JsonCreator
    public AggregatedStatusEventObject(@JsonProperty("type") AggregatedStatusObjectType type,
                                       @JsonProperty("id") Long id,
                                       @Nullable @JsonProperty("parent_id") Long parentId,
                                       @Nullable @JsonProperty("cid") Long campaignId,
                                       @JsonProperty("deleted") boolean deleted,
                                       @Nullable @JsonProperty("from_grut") Boolean fromGrut) {
        this.type = type;
        this.id = id;
        this.parentId = parentId;
        this.campaignId = campaignId;
        this.deleted = deleted;
        this.fromGrut = fromGrut;
    }

    public AggregatedStatusEventObject(AggregatedStatusObjectType type,
                                       Long id,
                                       @Nullable Long parentId,
                                       @Nullable Long campaignId,
                                       boolean deleted) {
        this(type, id, parentId, campaignId, deleted, false);
    }

    public static AggregatedStatusEventObject aggregateStatusOnBannerChange(Long bid, Long pid,
                                                                            @Nullable Long cid,
                                                                            boolean deleted,
                                                                            Boolean fromGrut) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.AD, bid, pid, cid, deleted, fromGrut);
    }

    public static AggregatedStatusEventObject aggregateStatusOnBannerChange(Long bid, Long pid,
                                                                            @Nullable Long cid,
                                                                            boolean deleted) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.AD, bid, pid, cid, deleted);
    }

    public static AggregatedStatusEventObject aggregateStatusOnModerateBannerPagesChange(Long bid) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.AD, bid, null, null, false);
    }

    public static AggregatedStatusEventObject aggregateStatusOnBannerTurbolandingsChange(Long bid) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.AD, bid, null, null, false);
    }

    public static AggregatedStatusEventObject aggregateStatusOnBannerDisplayHrefsChange(Long bid) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.AD, bid, null, null, false);
    }

    public static AggregatedStatusEventObject aggregateStatusOnBannerAdditionChange(Long bid) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.AD, bid, null, null, false);
    }

    public static AggregatedStatusEventObject aggregateStatusOnBannersMinusGeoChange(Long bid) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.RESTRICTED_GEO, bid, null, null, false);
    }

    public static AggregatedStatusEventObject aggregateStatusOnPerfCreativesChange(Long creativeId) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.PERF_CREATIVES, creativeId, null, null, false);
    }

    public static AggregatedStatusEventObject aggregateStatusOnCalloutChange(Long additionItemId) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.CALLOUT, additionItemId, null, null, false);
    }

    public static AggregatedStatusEventObject aggregateStatusOnImageChange(Long bid) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.AD, bid, null, null, false);
    }

    public static AggregatedStatusEventObject aggregateStatusOnKeywordChange(Long id, Long pid, Long cid, boolean deleted) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.KEYWORD, id, pid, cid, deleted);
    }

    public static AggregatedStatusEventObject aggregateStatusOnBidsBaseChange(Long id, Long pid) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.BID_BASE, id, pid, null, false);
    }

    public static AggregatedStatusEventObject aggregateStatusOnArchivedKeywordChange(Long id, Long pid, Long cid, boolean deleted) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.ARCHIVED_KEYWORD, id, pid, cid, deleted);
    }

    public static AggregatedStatusEventObject aggregateStatusOnRetargetingChange(Long retargetingId, Long pid, boolean deleted) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.RETARGETING, retargetingId, pid, null, deleted);
    }

    public static AggregatedStatusEventObject aggregateStatusOnShowConditionChange(Long pid) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.ADGROUP, pid, null, null, false);
    }

    public static AggregatedStatusEventObject aggregateStatusOnAdGroupChange(Long pid, Long cid, boolean deleted) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.ADGROUP, pid, cid, null, deleted);
    }

    public static AggregatedStatusEventObject aggregateStatusOnCampaignChange(Long cid, boolean deleted) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.CAMPAIGN, cid, null, null, deleted);
    }

    public static AggregatedStatusEventObject aggregateStatusOnPromoactionChange(Long promoactionId) {
        return new AggregatedStatusEventObject(AggregatedStatusObjectType.PROMO_EXTENSION, promoactionId, null, null, false);
    }

    public AggregatedStatusObjectType getType() {
        return type;
    }

    public Long getId() {
        return id;
    }

    @Nullable
    public Long getParentId() {
        return parentId;
    }

    @Nullable
    public Long getCampaignId() {
        return campaignId;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public Boolean getFromGrut() {
        return fromGrut;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AggregatedStatusEventObject that = (AggregatedStatusEventObject) o;
        return deleted == that.deleted &&
                type == that.type &&
                Objects.equals(id, that.id) &&
                Objects.equals(parentId, that.parentId) &&
                Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(fromGrut, that.fromGrut);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, id, parentId, campaignId, deleted, fromGrut);
    }
}
