package ru.yandex.direct.ess.logicobjects.brandliftrecalc;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.models.BaseLogicObject;

public class BrandLiftRecalcObject extends BaseLogicObject {
    @JsonProperty("cid")
    private Long cid;

    @JsonCreator
    public BrandLiftRecalcObject(@JsonProperty("cid") Long cid) {
        this.cid = cid;
    }

    public Long getCid() {
        return cid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BrandLiftRecalcObject that = (BrandLiftRecalcObject) o;
        return cid == that.cid;
    }

    @Override
    public int hashCode() {
        return Objects.hash(cid);
    }

    @Override
    public String toString() {
        return "BrandLiftRecalcObject{" +
                "cid=" + cid +
                '}';
    }
}
