package ru.yandex.direct.ess.logicobjects.bsexport.adgroup

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue
import com.fasterxml.jackson.annotation.JsonProperty
import com.fasterxml.jackson.annotation.JsonSubTypes
import com.fasterxml.jackson.annotation.JsonTypeInfo
import ru.yandex.direct.ess.common.models.BaseLogicObject
import ru.yandex.direct.ess.logicobjects.bsexport.DebugInfo

enum class AdGroupResourceType {
    @JsonEnumDefaultValue
    UNKNOWN,
    ALL,
    DELETE,

    COMMON_FIELDS, // общие для всех групп немодерируемые поля
    INTERNAL_AD_FIELDS, // поля специфичные для групп внутренней рекламы
    TEXT_FIELDS, // поля специфичные для ТГО групп
    MINUS_PHRASES,
    PAGE_GROUP_TAGS,
    MATCH_PRIORITY,
    TARGET_TAGS,
    CLICK_URL_TAIL,
    MULTIPLIERS,
    SHOW_CONDITIONS,
    SERP_PLACEMENT_TYPE,
    PRODUCT_GALLERY_ONLY, // не используется - дропнуть после выкатки релиза ess-router
    RELEVANCE_MATCH_DATA,
}

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    defaultImpl = UnknownInfo::class,
    property = "type")
@JsonSubTypes(
    JsonSubTypes.Type(MinusPhrasesInfo::class, name = "MinusPhrasesInfo"),
    JsonSubTypes.Type(MultiplierInfo::class, name = "MultiplierInfo"),
    JsonSubTypes.Type(RetargetingConditionInfo::class, name = "RetargetingConditionInfo"),
    JsonSubTypes.Type(ShowConditionsInfo::class, name = "ShowConditionsInfo"),
)
sealed class AdditionalInfo {
    val type: String = this::class.java.simpleName
}

data class MinusPhrasesInfo(
    @JsonProperty("minus_word_id")
    val minusWordId: Long
) : AdditionalInfo()

data class MultiplierInfo(
    @JsonProperty("hierarchical_multiplier_id") val hierarchicalMultiplierId: Long? = null,
    @JsonProperty("retargeting_condition_id") val retargetingConditionId: Long? = null
) : AdditionalInfo()

data class RetargetingConditionInfo(
    @JsonProperty("retargeting_condition_id")
    val retargetingConditionId: Long,
) : AdditionalInfo()

data class ShowConditionsInfo(
    @JsonProperty("mobile_content_id") val mobileContentId: Long? = null,
    @JsonProperty("banner_id") val bannerId: Long? = null,
) : AdditionalInfo()

class UnknownInfo : AdditionalInfo()

data class BsExportAdGroupObject(
    @JsonProperty("resource_type") val resourceType: AdGroupResourceType,
    @JsonProperty("adgroup_id") val adGroupId: Long?,
    @JsonProperty("campaign_id") val campaignId: Long?,
    @JsonProperty("debug_info") val debugInfo: DebugInfo? = null,
    @JsonProperty("additional_info") val additionalInfo: AdditionalInfo? = null
) : BaseLogicObject()
