package ru.yandex.direct.ess.logicobjects.bsexport.adgroup

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue
import com.fasterxml.jackson.annotation.JsonProperty
import ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType
import ru.yandex.direct.ess.common.models.BaseLogicObject
import ru.yandex.direct.ess.logicobjects.bsexport.DebugInfo

enum class AdGroupShowConditionType {
    @JsonEnumDefaultValue
    UNKNOWN,
    ALL,

    GEO,
    TIME,
    RF,
    ADDITIONAL_TARGETING,
    PLACE,
    GOAL_CONTEXT,
    MOBILE_CONTENT,
    TARGET_TAGS,
    PERFORMANCE,
    PAGE_BLOCKS,
}

class BsExportAdGroupShowConditionObject(
    @JsonProperty("adgroup_id") val adGroupId: Long?,
    @JsonProperty("campaign_id") val campaignId: Long?,
    @JsonProperty("type") val type: AdGroupShowConditionType,
    @JsonProperty("debug_info") val debugInfo: DebugInfo? = null,
    @JsonProperty("additional_targeting_type") val additionalTargetingType: AdgroupAdditionalTargetingsTargetingType? = null,
    @JsonProperty("mobile_content_id") val mobileContentId: Long? = null,
    @JsonProperty("banner_id") val bannerId: Long? = null,
) : BaseLogicObject()
