package ru.yandex.direct.ess.logicobjects.bsexport.bids

import java.util.EnumSet

enum class BidObjectType {
    KEYWORD,
    RETARGETING,
    DYNAMIC,
    PERFORMANCE,
    RELEVANCE_MATCH,

    // Офферный ретаргетинг для bids_base, это условие для смарт-баннера в ТГО-группе
    OFFER_RETARGETING,

    // Изменение параметров для keyword или relevance match ставок
    BIDS_HREF_PARAMS,

    // Изменение условия для bids_retargeting
    RETARGETING_CONDITION,

    // Изменение условия для bids_dynamic
    DYNAMIC_CONDITION;

    val isDeletionSupported
        get() = this in BID_TABLE_TYPES

    companion object {
        /**
         * Типы, соответствующие изменениям в табличках bids_****
         */
        val BID_TABLE_TYPES: Set<BidObjectType> = EnumSet.of(
            KEYWORD,
            RETARGETING,
            DYNAMIC,
            PERFORMANCE,
            OFFER_RETARGETING,
            RELEVANCE_MATCH
        )
    }
}
