package ru.yandex.direct.ess.logicobjects.bsexport.bids;

import java.util.Objects;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.models.BaseLogicObject;

public class BsExportBidsObject extends BaseLogicObject {
    @JsonProperty("cid")
    private Long cid;

    @JsonProperty("pid")
    private Long pid;

    @JsonProperty("bid")
    private Long id;

    @JsonProperty("bid_object_type")
    private BidObjectType bidObjectType;

    @JsonProperty("is_deleted")
    private boolean isDeleted;

    @JsonProperty("reqid")
    private Long reqid;

    @JsonProperty("service")
    private String service;

    @JsonProperty("method")
    private String method;

    @JsonCreator
    public BsExportBidsObject(
            @JsonProperty("cid") Long cid,
            @JsonProperty("pid") Long pid,
            @JsonProperty("bid") Long id,
            @JsonProperty("resource_type") BidObjectType bidObjectType,
            @JsonProperty("is_deleted") boolean isDeleted,
            @JsonProperty("reqid") Long reqId,
            @JsonProperty("service") String service,
            @JsonProperty("method") String method) {
        this.cid = cid;
        this.pid = pid;
        this.id = id;
        this.bidObjectType = bidObjectType;
        this.isDeleted = isDeleted;
        this.reqid = reqId;
        this.service = service;
        this.method = method;
    }

    public BsExportBidsObject(
            Long cid, Long pid, Long id,
            BidObjectType bidObjectType, boolean isDeleted) {
        this(cid, pid, id, bidObjectType, isDeleted, 0L, "", "");
    }

    @Nullable
    public Long getCid() {
        return cid;
    }

    @Nullable
    public Long getPid() {
        return pid;
    }

    public Long getId() {
        return id;
    }

    public BidObjectType getBidObjectType() {
        return bidObjectType;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public void setDeleted(boolean deleted) {
        isDeleted = deleted;
    }

    public void setReqid(Long reqid) {
        this.reqid = reqid;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Long getReqid() {
        return reqid;
    }

    public String getService() {
        return service;
    }

    public String getMethod() {
        return method;
    }

    @Override
    public String toString() {
        return "BsExportBidsObject{" +
                "cid=" + cid +
                ", pid=" + pid +
                ", id=" + id +
                ", bidObjectType=" + bidObjectType +
                ", isDeleted=" + isDeleted +
                ", reqid=" + reqid +
                ", service='" + service + '\'' +
                ", method='" + method + '\'' +
                "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BsExportBidsObject that = (BsExportBidsObject) o;
        return isDeleted == that.isDeleted &&
                Objects.equals(cid, that.cid) &&
                Objects.equals(pid, that.pid) &&
                Objects.equals(id, that.id) &&
                bidObjectType == that.bidObjectType &&
                Objects.equals(reqid, that.reqid) &&
                Objects.equals(service, that.service) &&
                Objects.equals(method, that.method);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cid, pid, id, bidObjectType, isDeleted, reqid, service, method);
    }
}
