package ru.yandex.direct.ess.logicobjects.bsexport.campaing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.models.BaseLogicObject;

import static com.google.common.base.Preconditions.checkArgument;

public class BsExportCampaignObject extends BaseLogicObject {
    @JsonProperty("cid")
    private final Long cid;

    @JsonProperty("order_id")
    private final Long orderId;

    @JsonProperty("hierarchical_multiplier_id")
    private final Long hierarchicalMultiplierId;

    @JsonProperty("retargeting_condition_id")
    private final Long retargetingConditionId;

    @JsonProperty("resource_type")
    private final CampaignResourceType campaignResourceType;

    @JsonProperty("additional_info")
    private final CampaignAdditionalInfo additionalInfo;

    @JsonProperty("reqid")
    private final Long reqid;

    @JsonProperty("service")
    private final String service;

    @JsonProperty("method")
    private final String method;

    @JsonProperty("brandsafety_ret_cond_id")
    private final Long brandsafetyRetCondId;

    @JsonCreator
    public BsExportCampaignObject(@JsonProperty("cid") Long cid,
                                  @JsonProperty("order_id") Long orderId,
                                  @JsonProperty("hierarchical_multiplier_id") Long hierarchicalMultiplierId,
                                  @JsonProperty("retargeting_condition_id") Long retargetingConditionId,
                                  @JsonProperty("brandsafety_ret_cond_id") Long brandsafetyRetCondId,
                                  @JsonProperty("resource_type") CampaignResourceType campaignResourceType,
                                  @JsonProperty("additional_info") CampaignAdditionalInfo additionalInfo,
                                  @JsonProperty("reqid") Long reqid,
                                  @JsonProperty("service") String service,
                                  @JsonProperty("method") String method) {
        checkArgument(cid != null || hierarchicalMultiplierId != null || retargetingConditionId != null
                || brandsafetyRetCondId != null || additionalInfo != null);
        this.cid = cid;
        this.orderId = orderId;
        this.hierarchicalMultiplierId = hierarchicalMultiplierId;
        this.retargetingConditionId = retargetingConditionId;
        this.brandsafetyRetCondId = brandsafetyRetCondId;
        this.campaignResourceType = campaignResourceType;
        this.additionalInfo = additionalInfo;
        this.reqid = reqid;
        this.service = service;
        this.method = method;
    }

    public Long getCid() {
        return cid;
    }

    public Long getOrderId() {
        return orderId;
    }

    public Long getHierarchicalMultiplierId() {
        return hierarchicalMultiplierId;
    }

    public Long getRetargetingConditionId() {
        return retargetingConditionId;
    }

    public CampaignAdditionalInfo getAdditionalInfo() {
        return additionalInfo;
    }

    public CampaignResourceType getCampaignResourceType() {
        return campaignResourceType;
    }

    public Long getBrandsafetyRetCondId() { return brandsafetyRetCondId; }

    public static class Builder {
        private Long cid;
        private Long orderId = null;
        private Long hierarchicalMultiplierId = null;
        private Long retargetingConditionId = null;
        private Long brandsafetyRetCondId = null;
        private CampaignResourceType campaignResourceType;
        private CampaignAdditionalInfo additionalInfo = null;
        private Long reqid = 0L;
        private String service = "";
        private String method = "";

        public Builder() {
            this.cid = null;
        }

        public Builder setCid(Long cid) {
            this.cid = cid;
            return this;
        }

        public Builder setOrderId(Long orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder setHierarchicalMultiplierId(Long hierarchicalMultiplierId) {
            this.hierarchicalMultiplierId = hierarchicalMultiplierId;
            return this;
        }

        public Builder setRetargetingConditionId(Long retargetingConditionId) {
            this.retargetingConditionId = retargetingConditionId;
            return this;
        }

        public Builder setBrandsafetyRetCondId(Long brandsafetyRetCondId) {
            this.brandsafetyRetCondId = brandsafetyRetCondId;
            return this;
        }

        public Builder setCampaignResourceType(CampaignResourceType campaignResourceType) {
            this.campaignResourceType = campaignResourceType;
            return this;
        }

        public Builder setAdditionalInfo(CampaignAdditionalInfo additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public Builder setReqid(Long reqid) {
            this.reqid = reqid;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public BsExportCampaignObject build() {
            return new BsExportCampaignObject(cid, orderId, hierarchicalMultiplierId,
                    retargetingConditionId, brandsafetyRetCondId,
                    campaignResourceType, additionalInfo, reqid, service, method);
        }
    }

    @Override
    public String toString() {
        return "BsExportCampaignObject{" +
                "cid=" + cid +
                ", orderId=" + orderId +
                ", hierarchicalMultiplierId=" + hierarchicalMultiplierId +
                ", retargetingConditionId=" + retargetingConditionId +
                ", brandsafetyRetCondId='" + brandsafetyRetCondId +
                ", campaignResourceType=" + campaignResourceType +
                ", additionalInfo=" + additionalInfo +
                ", reqid=" + reqid +
                ", service='" + service + '\'' +
                ", method='" + method + '\'' +
                '}';
    }
}
