package ru.yandex.direct.ess.logicobjects.bsexport.campaing

import com.fasterxml.jackson.annotation.JsonProperty
import com.fasterxml.jackson.annotation.JsonSubTypes
import com.fasterxml.jackson.annotation.JsonTypeInfo

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    defaultImpl = UnknownInfo::class,
    property = "type",
)
@JsonSubTypes(
    JsonSubTypes.Type(UnknownInfo::class, name = "UnknownInfo"),
    JsonSubTypes.Type(MultiplierInfo::class, name = "MultiplierInfo"),
    JsonSubTypes.Type(RetargetingConditionInfo::class, name = "RetargetingConditionInfo"),
    JsonSubTypes.Type(ClientAdditionalTargetingsInfo::class, name = "ClientAdditionalTargetingsInfo"),
)
sealed class CampaignAdditionalInfo

class UnknownInfo : CampaignAdditionalInfo()

data class MultiplierInfo(
    @JsonProperty("hierarchical_multiplier_id")
    val hierarchicalMultiplierId: Long,
) : CampaignAdditionalInfo()

data class RetargetingConditionInfo(
    @JsonProperty("retargeting_condition_id")
    val retargetingConditionId: Long,
) : CampaignAdditionalInfo()

data class ClientAdditionalTargetingsInfo(
    @JsonProperty("client_id")
    val clientId: Long,
) : CampaignAdditionalInfo()
