package ru.yandex.direct.ess.logicobjects.bsexport.feeds;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.models.BaseLogicObject;

public class BsExportFeedsObject extends BaseLogicObject {

    @JsonProperty("feed_id")
    private Long feedId;
    @JsonProperty("is_deleted")
    private boolean isDeleted;

    @JsonProperty("reqid")
    private Long reqid;

    @JsonProperty("service")
    private String service;

    @JsonProperty("method")
    private String method;

    @JsonCreator
    public BsExportFeedsObject(
            @JsonProperty("feed_id") Long feedId,
            @JsonProperty("is_deleted") boolean isDeleted,
            @JsonProperty("reqid") Long reqId,
            @JsonProperty("service") String service,
            @JsonProperty("method") String method) {
        this.feedId = feedId;
        this.isDeleted = isDeleted;
        this.reqid = reqId;
        this.service = service;
        this.method = method;
    }

    public BsExportFeedsObject(
            Long bid, boolean isDeleted) {
        this(bid, isDeleted, 0L, "", "");
    }

    public BsExportFeedsObject(Long bid) {
        this(bid, false);
    }

    public Long getFeedId() {
        return feedId;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public void setDeleted(boolean deleted) {
        isDeleted = deleted;
    }

    public void setReqid(Long reqid) {
        this.reqid = reqid;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Long getReqid() {
        return reqid;
    }

    public String getService() {
        return service;
    }

    public String getMethod() {
        return method;
    }

    @Override
    public String toString() {
        return "BsExportFeedsObject{" +
                "feedId=" + feedId +
                ", isDeleted=" + isDeleted +
                ", reqid=" + reqid +
                ", service='" + service + '\'' +
                ", method='" + method + '\'' +
                '}';
    }
}
