package ru.yandex.direct.ess.logicobjects.bsexport.meaningfulgoals;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.models.BaseLogicObject;

public class BsExportMeaningfulGoalsObject extends BaseLogicObject {
    @JsonProperty("campaign_id")
    private final Long campaignId;

    @JsonProperty("meaningful_goals")
    private final String meaningfulGoals;

    @JsonCreator
    public BsExportMeaningfulGoalsObject(@JsonProperty("campaign_id") Long campaignId,
                                         @JsonProperty("meaningful_goals") String meaningfulGoals) {
        this.campaignId = campaignId;
        this.meaningfulGoals = meaningfulGoals;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public String getMeaningfulGoals() {
        return meaningfulGoals;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BsExportMeaningfulGoalsObject that = (BsExportMeaningfulGoalsObject) o;
        return campaignId.equals(that.campaignId) &&
                Objects.equals(meaningfulGoals, that.meaningfulGoals);
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId, meaningfulGoals);
    }

    @Override
    public String toString() {
        return "BsExportMeaningfulGoalsObject{" +
                "campaignId=" + campaignId +
                ", meaningfulGoals='" + meaningfulGoals + '\'' +
                '}';
    }
}
