package ru.yandex.direct.ess.logicobjects.bsexport.mobilegoals;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.models.BaseLogicObject;

public class BsExportMobileGoalsExternalTrackerObject extends BaseLogicObject {

    @JsonProperty("goal_id")
    private Long goalId;

    @JsonProperty("is_deleted")
    private boolean isDeleted;

    @JsonProperty("reqid")
    private Long reqid;

    @JsonProperty("service")
    private String service;

    @JsonProperty("method")
    private String method;

    @JsonCreator
    public BsExportMobileGoalsExternalTrackerObject(
            @JsonProperty("goal_id") Long goalId,
            @JsonProperty("is_deleted") boolean isDeleted,
            @JsonProperty("reqid") Long reqId,
            @JsonProperty("service") String service,
            @JsonProperty("method") String method) {
        this.goalId = goalId;
        this.isDeleted = isDeleted;
        this.reqid = reqId;
        this.service = service;
        this.method = method;
    }

    public BsExportMobileGoalsExternalTrackerObject(
            Long bid, boolean isDeleted) {
        this(bid, isDeleted, 0L, "", "");
    }

    public BsExportMobileGoalsExternalTrackerObject(Long bid) {
        this(bid, false);
    }

    public Long getGoalId() {
        return goalId;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public void setDeleted(boolean deleted) {
        isDeleted = deleted;
    }

    public void setReqid(Long reqid) {
        this.reqid = reqid;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Long getReqid() {
        return reqid;
    }

    public String getService() {
        return service;
    }

    public String getMethod() {
        return method;
    }

    @Override
    public String toString() {
        return "BsExportgoalsObject{" +
                "goalId=" + goalId +
                ", isDeleted=" + isDeleted +
                ", reqid=" + reqid +
                ", service='" + service + '\'' +
                ", method='" + method + '\'' +
                '}';
    }
}
