package ru.yandex.direct.ess.logicobjects.bsexport.multipliers;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Событие, которое генерируется если изменилась доступность целей, входящих в условие ретаргетинга
 */
@ParametersAreNonnullByDefault
public class AccessibleGoalChangedInfo {
    @JsonProperty("retargeting_condition_id")
    private final Long retargetingConditionId;

    public AccessibleGoalChangedInfo(@JsonProperty("retargeting_condition_id") Long retargetingConditionId) {
        this.retargetingConditionId = retargetingConditionId;
    }

    public Long getRetargetingConditionId() {
        return retargetingConditionId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccessibleGoalChangedInfo that = (AccessibleGoalChangedInfo) o;
        return Objects.equals(retargetingConditionId, that.retargetingConditionId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(retargetingConditionId);
    }

    @Override
    public String toString() {
        return "AccessibleGoalChangedInfo{" +
                "retargetingConditionId=" + retargetingConditionId +
                '}';
    }
}
