package ru.yandex.direct.ess.logicobjects.bsexport.multipliers;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.models.BaseLogicObject;

import static com.google.common.base.Preconditions.checkArgument;

@ParametersAreNonnullByDefault
public class BsExportMultipliersObject extends BaseLogicObject {
    @JsonProperty("upsert_info")
    @Nullable
    private final UpsertInfo upsertInfo;

    @JsonProperty("delete_info")
    @Nullable
    private final DeleteInfo deleteInfo;

    @JsonProperty("accessible_goal_changed_info")
    @Nullable
    private final AccessibleGoalChangedInfo accessibleGoalChangedInfo;

    @JsonProperty("time_target_changed_info")
    @Nullable
    private final TimeTargetChangedInfo timeTargetChangedInfo;

    @JsonProperty("reqid")
    private final Long reqid;

    @JsonProperty("service")
    private final String service;

    @JsonProperty("method")
    private final String method;

    @JsonCreator
    private BsExportMultipliersObject(
            @JsonProperty("upsert_info") @Nullable UpsertInfo upsertInfo,
            @JsonProperty("delete_info") @Nullable DeleteInfo deleteInfo,
            @JsonProperty("accessible_goal_changed_info") @Nullable AccessibleGoalChangedInfo accessibleGoalChangedInfo,
            @JsonProperty("time_target_changed_info") @Nullable TimeTargetChangedInfo timeTargetChangedInfo,
            @JsonProperty("reqid") Long reqid,
            @JsonProperty("service") String service,
            @JsonProperty("method") String method) {
        checkArgument(upsertInfo != null ^ deleteInfo != null ^ accessibleGoalChangedInfo != null ^ timeTargetChangedInfo != null);
        this.upsertInfo = upsertInfo;
        this.deleteInfo = deleteInfo;
        this.accessibleGoalChangedInfo = accessibleGoalChangedInfo;
        this.timeTargetChangedInfo = timeTargetChangedInfo;
        this.reqid = reqid;
        this.service = service;
        this.method = method;
    }

    public static BsExportMultipliersObject upsert(UpsertInfo upsertInfo, Long reqid, String service, String method) {
        return new BsExportMultipliersObject(upsertInfo, null, null, null, reqid, service, method);
    }

    public static BsExportMultipliersObject delete(DeleteInfo deleteInfo, Long reqid, String service, String method) {
        return new BsExportMultipliersObject(null, deleteInfo, null, null, reqid, service, method);
    }

    public static BsExportMultipliersObject accessibleGoalChanged(
            AccessibleGoalChangedInfo accessibleGoalChangedInfo, Long reqid, String service, String method) {
        return new BsExportMultipliersObject(null, null, accessibleGoalChangedInfo, null, reqid,
                service, method);
    }

    public static BsExportMultipliersObject timeTargetChanged(
            TimeTargetChangedInfo timeTargetChangedInfo, Long reqid, String service, String method) {
        return new BsExportMultipliersObject(null, null, null, timeTargetChangedInfo, reqid,
                service, method);
    }

    @Nullable
    public UpsertInfo getUpsertInfo() {
        return upsertInfo;
    }

    @Nullable
    public DeleteInfo getDeleteInfo() {
        return deleteInfo;
    }

    @Nullable
    public AccessibleGoalChangedInfo getAccessibleGoalChangedInfo() {
        return accessibleGoalChangedInfo;
    }

    @Nullable
    public TimeTargetChangedInfo getTimeTargetChangedInfo() {
        return timeTargetChangedInfo;
    }

    public Long getReqid() {
        return reqid;
    }

    public String getService() {
        return service;
    }

    public String getMethod() {
        return method;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BsExportMultipliersObject that = (BsExportMultipliersObject) o;
        return Objects.equals(upsertInfo, that.upsertInfo) &&
                Objects.equals(deleteInfo, that.deleteInfo) &&
                Objects.equals(accessibleGoalChangedInfo, that.accessibleGoalChangedInfo) &&
                Objects.equals(timeTargetChangedInfo, that.timeTargetChangedInfo) &&
                Objects.equals(reqid, that.reqid) &&
                Objects.equals(service, that.service) &&
                Objects.equals(method, that.method);
    }

    @Override
    public int hashCode() {
        return Objects.hash(upsertInfo, deleteInfo, accessibleGoalChangedInfo, timeTargetChangedInfo, reqid,
                service, method);
    }

    @Override
    public String toString() {
        return "BsExportMultipliersObject{" +
                "upsertInfo=" + upsertInfo +
                ", deleteInfo=" + deleteInfo +
                ", accessibleGoalChangedInfo=" + accessibleGoalChangedInfo +
                ", timeTargetChangedInfo=" + timeTargetChangedInfo +
                ", reqid=" + reqid +
                ", service='" + service + '\'' +
                ", method='" + method + '\'' +
                '}';
    }
}
