package ru.yandex.direct.ess.logicobjects.bsexport.multipliers;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class DeleteInfo {
    @JsonProperty("multiplier_type")
    private final MultiplierType multiplierType;

    @JsonProperty("campaign_id")
    private final Long campaignId;

    @JsonProperty("adgroup_id")
    @Nullable
    private final Long adGroupId;

    @JsonCreator
    public DeleteInfo(
            @JsonProperty("multiplier_type") MultiplierType multiplierType,
            @JsonProperty("campaign_id") Long campaignId,
            @JsonProperty("adgroup_id") @Nullable Long adGroupId) {
        this.multiplierType = multiplierType;
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
    }

    public MultiplierType getMultiplierType() {
        return multiplierType;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    @Nullable
    public Long getAdGroupId() {
        return adGroupId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeleteInfo that = (DeleteInfo) o;
        return multiplierType == that.multiplierType &&
                Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(adGroupId, that.adGroupId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(multiplierType, campaignId, adGroupId);
    }

    @Override
    public String toString() {
        return "DeleteInfo{" +
                "multiplierType=" + multiplierType +
                ", campaignId=" + campaignId +
                ", adGroupId=" + adGroupId +
                '}';
    }
}
