package ru.yandex.direct.ess.logicobjects.bsexport.multipliers;

import java.util.Arrays;
import java.util.List;

import ru.yandex.direct.dbschema.ppc.enums.HierarchicalMultipliersType;

public enum MultiplierType {
    WEATHER(HierarchicalMultipliersType.weather_multiplier),
    TRAFFIC(HierarchicalMultipliersType.express_traffic_multiplier),
    CONTENT_DURATION(HierarchicalMultipliersType.express_content_duration_multiplier),
    DEMOGRAPHY(HierarchicalMultipliersType.demography_multiplier),
    RETARGETING(HierarchicalMultipliersType.retargeting_multiplier, HierarchicalMultipliersType.retargeting_filter),
    GEO(HierarchicalMultipliersType.geo_multiplier),
    DEVICE(HierarchicalMultipliersType.mobile_multiplier,
            HierarchicalMultipliersType.desktop_multiplier,
            HierarchicalMultipliersType.smarttv_multiplier,
            HierarchicalMultipliersType.tablet_multiplier,
            HierarchicalMultipliersType.desktop_only_multiplier),
    INVENTORY(HierarchicalMultipliersType.banner_type_multiplier, HierarchicalMultipliersType.inventory_multiplier),
    AB_SEGMENT(HierarchicalMultipliersType.ab_segment_multiplier),
    AUTO_VIDEO_DIRECT(HierarchicalMultipliersType.video_multiplier),
    PERFORMANCE_TGO(HierarchicalMultipliersType.performance_tgo_multiplier),
    PRISMA_INCOME_MULTIPLIER(HierarchicalMultipliersType.prisma_income_grade_multiplier),
    TIME_TARGET(); // time target хранится на кампании

    private final List<HierarchicalMultipliersType> dbTypes;

    MultiplierType(HierarchicalMultipliersType... dbTypes) {
        this.dbTypes = List.copyOf(Arrays.asList(dbTypes));
    }

    public List<HierarchicalMultipliersType> getDbTypes() {
        return dbTypes;
    }
}
