package ru.yandex.direct.ess.logicobjects.bsexport.multipliers;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Событие об изменении timeTarget на кампании
 */
@ParametersAreNonnullByDefault
public class TimeTargetChangedInfo {
    @JsonProperty("campaign_id")
    private final Long campaignId;

    public TimeTargetChangedInfo(@JsonProperty("campaign_id") Long campaignId) {
        this.campaignId = campaignId;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TimeTargetChangedInfo that = (TimeTargetChangedInfo) o;
        return Objects.equals(campaignId, that.campaignId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaignId);
    }

    @Override
    public String toString() {
        return "TimeTargetChangedInfo{" +
                "campaignId=" + campaignId +
                '}';
    }
}
