package ru.yandex.direct.ess.logicobjects.bsexport.multipliers;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

@ParametersAreNonnullByDefault
public class UpsertInfo {
    @JsonProperty("multiplier_type")
    private final MultiplierType multiplierType;

    @JsonProperty("hierarchical_multiplier_id")
    private final Long hierarchicalMultiplierId;

    @JsonCreator
    public UpsertInfo(
            @JsonProperty("multiplier_type") MultiplierType multiplierType,
            @JsonProperty("hierarchical_multiplier_id") Long hierarchicalMultiplierId) {
        this.multiplierType = multiplierType;
        this.hierarchicalMultiplierId = hierarchicalMultiplierId;
    }

    public MultiplierType getMultiplierType() {
        return multiplierType;
    }

    public Long getHierarchicalMultiplierId() {
        return hierarchicalMultiplierId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpsertInfo that = (UpsertInfo) o;
        return multiplierType == that.multiplierType &&
                Objects.equals(hierarchicalMultiplierId, that.hierarchicalMultiplierId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(multiplierType, hierarchicalMultiplierId);
    }

    @Override
    public String toString() {
        return "UpsertInfo{" +
                "multiplierType=" + multiplierType +
                ", hierarchicalMultiplierId=" + hierarchicalMultiplierId +
                '}';
    }
}
