package ru.yandex.direct.ess.logicobjects.bsexport.resources;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

import ru.yandex.direct.ess.common.utils.TablesEnum;

public class AdditionalInfo {
    @JsonProperty("additional_table")
    private final TablesEnum additionalTable;

    @JsonProperty("additional_id")
    private final Long additionalId;
    public AdditionalInfo(
            @JsonProperty("additional_table") TablesEnum additionalTable,
            @NotNull @JsonProperty("additional_id") Long additionalId
    ) {
        this.additionalTable = additionalTable;
        this.additionalId = additionalId;
    }

    public TablesEnum getAdditionalTable() {
        return additionalTable;
    }

    @NotNull
    public Long getAdditionalId() {
        return additionalId;
    }

    @Override
    public String toString() {
        return "AdditionalInfo{" +
                "additionalTable=" + additionalTable +
                ", additionalId=" + additionalId +
                '}';
    }
}
