package ru.yandex.direct.ess.logicobjects.bsexport.resources;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import one.util.streamex.StreamEx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static ru.yandex.direct.ess.logicobjects.bsexport.resources.BannerResourceType.UNKNOWN;

public class BannerResourceTypeDeserializer extends JsonDeserializer<BannerResourceType> {

    private static final Logger logger = LoggerFactory.getLogger(BannerResourceTypeDeserializer.class);

    @Override
    public BannerResourceType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        var stringResourceType = p.getValueAsString().toLowerCase();
        var resourceType = StreamEx.of(BannerResourceType.values())
                .filter(type -> type.name().equalsIgnoreCase(stringResourceType))
                .findFirst()
                .orElse(UNKNOWN);
        if (UNKNOWN.equals(resourceType)) {
            logger.warn("Unknown resource type {}", stringResourceType);
        }
        return resourceType;
    }
}
