package ru.yandex.direct.ess.logicobjects.bsexport.resources;

import java.util.Objects;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.common.utils.TablesEnum;

public class BsExportBannerResourcesObject extends BaseLogicObject {

    @JsonProperty("bid")
    @Nullable
    private final Long bid;

    @JsonProperty("pid")
    @Nullable
    private final Long pid;

    @JsonProperty("cid")
    @Nullable
    private final Long cid;

    @JsonProperty("banner_id")
    @Nullable
    private final Long bannerId;

    @JsonDeserialize(using = BannerResourceTypeDeserializer.class)
    @JsonProperty("resource_type")
    private final BannerResourceType resourceType;

    @JsonProperty("is_deleted")
    private boolean isDeleted;

    @JsonProperty("additional_info")
    @Nullable
    private final AdditionalInfo additionalInfo;

    @JsonProperty("is_image_banner_exclusive")
    @Nullable
    private boolean isImageBannerExclusive;

    @JsonProperty("debug_info")
    @Nullable
    private DebugInfo debugInfo;

    @JsonCreator
    private BsExportBannerResourcesObject(
            @Nullable @JsonProperty("bid") Long bid,
            @Nullable @JsonProperty("pid") Long pid,
            @Nullable @JsonProperty("cid") Long cid,
            @Nullable @JsonProperty("banner_id") Long bannerId,
            @JsonProperty("resource_type") BannerResourceType resourceType,
            @JsonProperty("is_deleted") boolean isDeleted,
            @Nullable @JsonProperty("additional_info") AdditionalInfo additionalInfo,
            @JsonProperty("is_image_banner_exclusive") boolean isImageBannerExclusive,
            @Nullable @JsonProperty("debug_info") DebugInfo debugInfo) {
        this.bid = bid;
        this.pid = pid;
        this.cid = cid;
        this.bannerId = bannerId;
        this.resourceType = resourceType;
        this.isDeleted = isDeleted;
        this.additionalInfo = additionalInfo;
        this.isImageBannerExclusive = isImageBannerExclusive;
        this.debugInfo = debugInfo;
    }

    public Long getBid() {
        return bid;
    }

    public Long getPid() {
        return pid;
    }

    public Long getCid() {
        return cid;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public BannerResourceType getResourceType() {
        return resourceType;
    }

    public boolean isDeleted() {
        return isDeleted;
    }

    public void setDeleted(boolean deleted) {
        isDeleted = deleted;
    }

    public void setDebugInfo(DebugInfo debugInfo) {
        this.debugInfo = debugInfo;
    }

    @Nullable
    public DebugInfo getDebugInfo() {
        return debugInfo;
    }

    @Nullable
    public AdditionalInfo getAdditionalInfo() {
        return additionalInfo;
    }

    public boolean isImageBannerExclusive() {
        return isImageBannerExclusive;
    }

    public static class Builder {
        private Long bid;
        private Long pid;
        private Long cid;
        private Long bannerId;
        private BannerResourceType resourceType;
        private boolean isDeleted = false;
        private TablesEnum additionalTable;
        private Long additionalId;
        private boolean isImageBannerExclusive = false;
        private Long reqid = 0L;
        private String service = "";
        private String method = "";

        public Builder setBid(Long bid) {
            this.bid = bid;
            return this;
        }

        public Builder setPid(Long pid) {
            this.pid = pid;
            return this;
        }

        public Builder setCid(Long cid) {
            this.cid = cid;
            return this;
        }

        public Builder setBannerId(Long bannerId) {
            this.bannerId = bannerId;
            return this;
        }

        public Builder setResourceType(BannerResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder setDeleted(boolean deleted) {
            isDeleted = deleted;
            return this;
        }

        public Builder setAdditionalTable(TablesEnum additionalTable) {
            this.additionalTable = additionalTable;
            return this;
        }

        public Builder setAdditionalId(Long additionalId) {
            this.additionalId = additionalId;
            return this;
        }

        public Builder setImageBannerExclusive(boolean isImageBannerExclusive) {
            this.isImageBannerExclusive = isImageBannerExclusive;
            return this;
        }

        public Builder setReqid(Long reqid) {
            this.reqid = reqid;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public BsExportBannerResourcesObject build() {
            var debugInfo = new DebugInfo(reqid, service, method);
            var additionalInfo = Objects.nonNull(additionalId) ?
                    new AdditionalInfo(additionalTable, additionalId) : null;
            return new BsExportBannerResourcesObject(bid, pid, cid, bannerId, resourceType, isDeleted,
                    additionalInfo, isImageBannerExclusive, debugInfo);
        }
    }

    @Override
    public String toString() {
        return "BsExportBannerResourcesObject{" +
                "bid=" + bid +
                ", pid=" + pid +
                ", cid=" + cid +
                ", bannerId=" + bannerId +
                ", resourceType=" + resourceType +
                ", isDeleted=" + isDeleted +
                ", additionalInfo=" + additionalInfo +
                ", isImageBannerExclusive=" + isImageBannerExclusive +
                ", debugInfo=" + debugInfo +
                '}';
    }
}
