package ru.yandex.direct.ess.logicobjects.bsexport.resources;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class DebugInfo {
    @JsonProperty("reqid")
    private Long reqid;

    @JsonProperty("service")
    private String service;

    @JsonProperty("method")
    private String method;

    @JsonCreator
    public DebugInfo(
            @JsonProperty("reqid") Long reqid,
            @JsonProperty("service") String service,
            @JsonProperty("method") String method) {
        this.reqid = reqid;
        this.service = service;
        this.method = method;
    }

    public Long getReqid() {
        return reqid;
    }

    public String getService() {
        return service;
    }

    public String getMethod() {
        return method;
    }

    @Override
    public String toString() {
        return "DebugInfo{" +
                "reqid=" + reqid +
                ", service='" + service + '\'' +
                ", method='" + method + '\'' +
                '}';
    }
}
