package ru.yandex.direct.ess.logicobjects.bsexport.strategy

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonEnumDefaultValue
import com.fasterxml.jackson.annotation.JsonProperty
import ru.yandex.direct.ess.common.models.BaseLogicObject
import javax.annotation.ParametersAreNonnullByDefault

enum class StrategyResourceType {
    ALL,
    COMMON_FIELDS,
    METRIKA_COUNTER_IDS,
    DAY_BUDGET,
    MEANINGFUL_GOALS,
    INVENTORI_DATA,
    AUTOBUDGET_RESTART,

    @JsonEnumDefaultValue
    UNKNOWN
}

@ParametersAreNonnullByDefault
class BsExportStrategyObject @JsonCreator constructor(
    @field:JsonProperty("strategy_id") val strategyId: Long,
    @field:JsonProperty("resource_type") val strategyResourceType: StrategyResourceType,
    @field:JsonProperty("reqid") val reqid: Long,
    @field:JsonProperty("service") val service: String,
    @field:JsonProperty("method") val method: String
) : BaseLogicObject() {

    override fun toString(): String {
        return "BsExportStrategyObject{" +
            "strategyId=" + strategyId +
            ", strategyResourceType=" + strategyResourceType +
            ", reqid=" + reqid +
            ", service='" + service + '\'' +
            ", method='" + method + '\'' +
            '}'
    }
}


