package ru.yandex.direct.ess.logicobjects.campaignlastchange;

import java.time.LocalDateTime;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.common.utils.TablesEnum;

public class CampAggregatedLastchangeObject extends BaseLogicObject {
    @JsonProperty("changed_table")
    private TablesEnum changedTable;

    @JsonProperty("primary_key")
    private Long primaryKey;

    /* вспомогательный id - для banner_images то bid (может отсутсвовать), для banners и phrases это cid */
    @JsonProperty("id")
    private Long id;

    @JsonProperty("last_change")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime lastChange;

    @JsonCreator
    public CampAggregatedLastchangeObject(
            @JsonProperty("changed_table") TablesEnum changedTable,
            @JsonProperty("primary_key") Long primaryKey,
            @JsonProperty("id") Long id,
            @JsonProperty("last_change") @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm" +
                    ":ss") LocalDateTime lastChange
    ) {
        this.changedTable = changedTable;
        this.primaryKey = primaryKey;
        this.id = id;
        this.lastChange = lastChange;
    }

    public TablesEnum getChangedTable() {
        return changedTable;
    }

    public Long getPrimaryKey() {
        return primaryKey;
    }

    public LocalDateTime getLastChange() {
        return lastChange;
    }

    public Long getId() {
        return id;
    }

    @Override
    public String toString() {
        return "CampAggregatedLastchangeObject{"
                + "changedTable=" + changedTable
                + ", primary_key=" + primaryKey
                + ", id=" + id
                + ", lastChange=" + lastChange
                + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampAggregatedLastchangeObject that = (CampAggregatedLastchangeObject) o;
        return changedTable == that.changedTable &&
                Objects.equals(primaryKey, that.primaryKey) &&
                Objects.equals(id, that.id) &&
                Objects.equals(lastChange, that.lastChange);
    }

    @Override
    public int hashCode() {
        return Objects.hash(changedTable, primaryKey, id, lastChange);
    }
}
