package ru.yandex.direct.ess.logicobjects.campaignstatuscorrect;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.models.BaseLogicObject;

public class CampaignStatusCorrectCheckObject extends BaseLogicObject {

    @JsonProperty("cid")
    private Long cid;

    @JsonCreator
    public CampaignStatusCorrectCheckObject(
            @JsonProperty("cid") Long cid
    ) {
        this.cid = cid;
    }

    public Long getCid() {
        return cid;
    }

    @Override
    public String toString() {
        return "CampaignStatusCorrectCheckObject{"
                + ", cid=" + cid
                + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignStatusCorrectCheckObject that = (CampaignStatusCorrectCheckObject) o;
        return Objects.equals(cid, that.cid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(cid);
    }
}
