package ru.yandex.direct.ess.logicobjects.campeventlog;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.ess.common.models.BaseLogicObject;

public class CampaignEventLogLogicObject extends BaseLogicObject {

    @JsonProperty("event_time")
    private LocalDateTime eventTime;

    @JsonProperty("cid")
    private Long campaignId;

    @JsonProperty("client_id")
    private ClientId clientId;

    @JsonProperty("budget_type")
    private BudgetType budgetType;

    @JsonProperty("campaign_event_type")
    private CampaignEventType campaignEventType;

    @JsonProperty("budget_before")
    private BigDecimal budgetBefore;

    @JsonProperty("budget_after")
    private BigDecimal budgetAfter;

    @JsonProperty("avg_cpa_before")
    private BigDecimal avgCpaBefore;

    @JsonProperty("avg_cpa_after")
    private BigDecimal avgCpaAfter;

    @JsonProperty("roi_coef_before")
    private BigDecimal roiCoefBefore;

    @JsonProperty("roi_coef_after")
    private BigDecimal roiCoefAfter;

    public LocalDateTime getEventTime() {
        return eventTime;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public BudgetType getBudgetType() {
        return budgetType;
    }

    public CampaignEventType getCampaignEventType() {
        return campaignEventType;
    }

    public BigDecimal getBudgetBefore() {
        return budgetBefore;
    }

    public BigDecimal getBudgetAfter() {
        return budgetAfter;
    }

    public BigDecimal getAvgCpaBefore() {
        return avgCpaBefore;
    }

    public BigDecimal getAvgCpaAfter() {
        return avgCpaAfter;
    }

    public BigDecimal getRoiCoefBefore() {
        return roiCoefBefore;
    }

    public BigDecimal getRoiCoefAfter() {
        return roiCoefAfter;
    }

    public CampaignEventLogLogicObject withEventTime(LocalDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public CampaignEventLogLogicObject withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public CampaignEventLogLogicObject withClientId(ClientId clientId) {
        this.clientId = clientId;
        return this;
    }

    public CampaignEventLogLogicObject withBudgetType(BudgetType budgetType) {
        this.budgetType = budgetType;
        return this;
    }

    public CampaignEventLogLogicObject withCampaignEventType(CampaignEventType campaignEventType) {
        this.campaignEventType = campaignEventType;
        return this;
    }

    public CampaignEventLogLogicObject withBudgetBefore(BigDecimal budgetBefore) {
        this.budgetBefore = budgetBefore;
        return this;
    }

    public CampaignEventLogLogicObject withBudgetAfter(BigDecimal budgetAfter) {
        this.budgetAfter = budgetAfter;
        return this;
    }

    public CampaignEventLogLogicObject withAvgCpaBefore(BigDecimal avgCpaBefore) {
        this.avgCpaBefore = avgCpaBefore;
        return this;
    }

    public CampaignEventLogLogicObject withAvgCpaAfter(BigDecimal avgCpaAfter) {
        this.avgCpaAfter = avgCpaAfter;
        return this;
    }

    public CampaignEventLogLogicObject withRoiCoefBefore(BigDecimal roiCoefBefore) {
        this.roiCoefBefore = roiCoefBefore;
        return this;
    }

    public CampaignEventLogLogicObject withRoiCoefAfter(BigDecimal roiCoefAfter) {
        this.roiCoefAfter = roiCoefAfter;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CampaignEventLogLogicObject that = (CampaignEventLogLogicObject) o;
        return Objects.equals(eventTime, that.eventTime) &&
                Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(clientId, that.clientId) &&
                budgetType == that.budgetType &&
                campaignEventType == that.campaignEventType &&
                Objects.equals(budgetBefore, that.budgetBefore) &&
                Objects.equals(budgetAfter, that.budgetAfter) &&
                Objects.equals(avgCpaBefore, that.avgCpaBefore) &&
                Objects.equals(avgCpaAfter, that.avgCpaAfter) &&
                Objects.equals(roiCoefBefore, that.roiCoefBefore) &&
                Objects.equals(roiCoefAfter, that.roiCoefAfter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(eventTime, campaignId, clientId, campaignEventType, budgetBefore, budgetAfter, avgCpaBefore, avgCpaAfter, roiCoefBefore, roiCoefAfter);
    }

    //todo Удалить, оставлено для совместимости
    public enum BudgetType {
        DAILY,
        WEEKLY
    }

    public enum CampaignEventType {
        DAILY_BUDGET_CHANGED,
        WEEKLY_BUDGET_CHANGED,
        AVG_CPA_CHANGED,
        ROI_COEF_CHANGED
    }
}
