package ru.yandex.direct.ess.logicobjects.image;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;

public class ImageModerationEventsObject extends BaseModerationObject {

    @JsonProperty("image_id")
    private final long imageId;

    @JsonCreator
    public ImageModerationEventsObject(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("image_id") long imageId,
            @JsonProperty("was_copied") Boolean wasCopied) {
        super(essTag, eventTime, wasCopied);
        this.imageId = imageId;
    }

    public Long getImageId() {
        return imageId;
    }

    @Override
    public Long getObjectId() {
        return imageId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        if (!super.equals(o)) {
            return false;
        }
        ImageModerationEventsObject that = (ImageModerationEventsObject) o;
        return imageId == that.imageId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), imageId);
    }
}
