package ru.yandex.direct.ess.logicobjects.mediascopeintegration;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.models.BaseLogicObject;

public class MediascopePositionChangeObject extends BaseLogicObject {

    @JsonProperty("campaignId")
    private Long campaignId;

    @JsonProperty("bannerId")
    private Long bannerId;

    @JsonCreator
    public MediascopePositionChangeObject(
            @JsonProperty("campaignId") Long campaignId,
            @JsonProperty("bannerId") Long bannerId
    ) {
        this.campaignId = campaignId;
        this.bannerId = bannerId;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public Long getBannerId() {
        return bannerId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        MediascopePositionChangeObject that = (MediascopePositionChangeObject) o;

        if (!Objects.equals(campaignId, that.campaignId)) {
            return false;
        }
        return Objects.equals(bannerId, that.bannerId);

    }

    @Override
    public int hashCode() {
        int result = campaignId != null ? campaignId.hashCode() : 0;
        result = 31 * result + (bannerId != null ? bannerId.hashCode() : 0);
        return result;
    }
}
