package ru.yandex.direct.ess.logicobjects.metrika.bannerupdate;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.models.BaseLogicObject;
import ru.yandex.direct.ess.common.utils.TablesEnum;

public class MetrikaBannerUpdateObject extends BaseLogicObject {
    @JsonProperty("table")
    private TablesEnum table;

    @JsonProperty("primary_key")
    private Long primaryKey;

    @JsonCreator
    public MetrikaBannerUpdateObject(
            @JsonProperty("table") TablesEnum table,
            @JsonProperty("primary_key") Long primaryKey) {
        this.table = table;
        this.primaryKey = primaryKey;
    }

    public TablesEnum getTable() {
        return table;
    }

    public Long getPrimaryKey() {
        return primaryKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MetrikaBannerUpdateObject that = (MetrikaBannerUpdateObject) o;
        return table == that.table &&
                Objects.equals(primaryKey, that.primaryKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(table, primaryKey);
    }

    @Override
    public String toString() {
        return "MetrikaBannerUpdateObject{" +
                "table=" + table +
                ", primaryKey=" + primaryKey +
                '}';
    }
}
