package ru.yandex.direct.ess.logicobjects.moderation;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.common.models.BaseLogicObject;

/**
 * Некоторое событие в Директе, о котором необходимо сообщить Модерации.
 */
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public abstract class AbstractModerationEvent extends BaseLogicObject {

    @JsonProperty("ess_tag")
    private final String essTag;

    @JsonProperty("event_time")
    private final Long eventTime;

    public AbstractModerationEvent(String essTag,
                                   Long eventTime) {
        this.essTag = essTag;
        this.eventTime = eventTime;
    }

    public String getEssTag() {
        return essTag;
    }

    public Long getEventTime() {
        return eventTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AbstractModerationEvent that = (AbstractModerationEvent) o;
        return Objects.equals(essTag, that.essTag) && Objects.equals(eventTime, that.eventTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(essTag, eventTime);
    }

    @Override
    public String toString() {
        return "AbstractModerationEvent{" +
                "essTag='" + essTag + '\'' +
                ", eventTime=" + eventTime +
                '}';
    }
}
