package ru.yandex.direct.ess.logicobjects.moderation;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import static ru.yandex.direct.utils.CommonUtils.nvl;

/**
 * Событие в Директе, которое требует перемодерации объекта.
 */
@JsonInclude(value = JsonInclude.Include.NON_NULL)
public abstract class BaseModerationObject extends AbstractModerationEvent {

    @JsonProperty("was_copied")
    private final Boolean wasCopied;

    public BaseModerationObject(String essTag,
                                Long eventTime,
                                Boolean wasCopied) {
        super(essTag, eventTime);
        this.wasCopied = nvl(wasCopied, false);
    }

    public abstract Long getObjectId();

    public Boolean getWasCopied() {
        return wasCopied;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseModerationObject that = (BaseModerationObject) o;
        return Objects.equals(wasCopied, that.wasCopied);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), wasCopied);
    }

    @Override
    public String toString() {
        return "BaseModerationObject{" +
                "wasCopied=" + wasCopied +
                '}' + super.toString();
    }
}
