package ru.yandex.direct.ess.logicobjects.moderation.adgroup;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;

public class AdGroupModerationEventObject extends BaseModerationObject {

    @JsonProperty("adgroup_id")
    private Long adGroupId;

    @JsonCreator
    public AdGroupModerationEventObject(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("adgroup_id") Long adGroupId,
            @JsonProperty("was_copied") Boolean wasCopied) {
        super(essTag, eventTime, wasCopied);
        this.adGroupId = adGroupId;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdGroupModerationEventObject that = (AdGroupModerationEventObject) o;
        return Objects.equals(adGroupId, that.adGroupId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), adGroupId);
    }

    @Override
    public Long getObjectId() {
        return adGroupId;
    }

    @Override
    public String toString() {
        return "AdGroupModerationEventObject{" +
                "adGroupId=" + adGroupId +
                '}' + super.toString();
    }
}
