package ru.yandex.direct.ess.logicobjects.moderation.banner;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;
import ru.yandex.direct.ess.logicobjects.moderation.ModerationEventsObjectWithBannerId;

public class BannerModerationEventsObject extends BaseModerationObject implements ModerationEventsObjectWithBannerId {

    @JsonProperty("campaign_id")
    private final Long campaignId;

    @JsonProperty("adgroup_id")
    private final Long adGroupId;

    @JsonProperty("banner_id")
    private final Long bannerId;

    @JsonProperty("banner_type")
    private final BannersBannerType bannersBannerType;

    @JsonProperty("is_flags_only")
    private final Boolean isFlagsOnly;

    @JsonCreator
    public BannerModerationEventsObject(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("campaign_id") Long campaignId,
            @JsonProperty("adgroup_id") Long adGroupId,
            @JsonProperty("banner_id") Long bannerId,
            @JsonProperty("banner_type") BannersBannerType bannersBannerType,
            @JsonProperty("was_copied") Boolean wasCopied,
            @JsonProperty("is_flags_only") Boolean isFlagsOnly) {
        super(essTag, eventTime, wasCopied);
        this.campaignId = campaignId;
        this.adGroupId = adGroupId;
        this.bannerId = bannerId;
        this.bannersBannerType = bannersBannerType;
        this.isFlagsOnly = isFlagsOnly;
    }

    @Override
    public Long getObjectId() {
        return bannerId;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public Long getAdGroupId() {
        return adGroupId;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public BannersBannerType getBannersBannerType() {
        return bannersBannerType;
    }

    public Boolean getFlagsOnly() {
        return isFlagsOnly;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BannerModerationEventsObject that = (BannerModerationEventsObject) o;
        return Objects.equals(campaignId, that.campaignId) && Objects.equals(adGroupId, that.adGroupId) && Objects.equals(bannerId, that.bannerId) && bannersBannerType == that.bannersBannerType && Objects.equals(isFlagsOnly, that.isFlagsOnly);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), campaignId, adGroupId, bannerId, bannersBannerType, isFlagsOnly);
    }

    @Override
    public String toString() {
        return "BannerModerationEventsObject{" +
                "campaignId=" + campaignId +
                ", adGroupId=" + adGroupId +
                ", bannerId=" + bannerId +
                ", bannersBannerType=" + bannersBannerType +
                ", isFlagsOnly=" + isFlagsOnly +
                '}' + super.toString();
    }
}
