package ru.yandex.direct.ess.logicobjects.moderation.bannerpages;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;
import ru.yandex.direct.ess.logicobjects.moderation.ModerationEventsObjectWithBannerId;

public final class BannerPagesModerationLogicObject extends BaseModerationObject implements ModerationEventsObjectWithBannerId {

    @JsonProperty("banner_id")
    private final Long bannerId;

    @JsonProperty("page_id")
    private final Long pageId;

    @JsonProperty("version")
    private final Long version;

    @JsonProperty("status_moderate")
    private final String statusModerate;

    @JsonCreator
    public BannerPagesModerationLogicObject(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("banner_id") Long bannerId,
            @JsonProperty("page_id") Long pageId,
            @JsonProperty("version") Long version,
            @JsonProperty("status_moderate") String statusModerate,
            @JsonProperty("was_copied") Boolean wasCopied
    ) {
        super(essTag, eventTime, wasCopied);
        this.bannerId = bannerId;
        this.pageId = pageId;
        this.version = version;
        this.statusModerate = statusModerate;
    }

    public Long getBannerId() {
        return bannerId;
    }

    public Long getPageId() {
        return pageId;
    }

    public Long getVersion() {
        return version;
    }

    public String getStatusModerate() {
        return statusModerate;
    }

    @Override
    public Long getObjectId() {
        return bannerId;
    }

    @Override
    public String toString() {
        return "BannerPagesModerationLogicObject{" +
                "bannerId=" + bannerId +
                ", pageId=" + pageId +
                ", version=" + version +
                ", statusModerate='" + statusModerate + '\'' +
                "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BannerPagesModerationLogicObject that = (BannerPagesModerationLogicObject) o;
        return Objects.equals(bannerId, that.bannerId) &&
                Objects.equals(pageId, that.pageId) &&
                Objects.equals(version, that.version) &&
                Objects.equals(statusModerate, that.statusModerate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), bannerId, pageId, version, statusModerate);
    }
}
