package ru.yandex.direct.ess.logicobjects.moderation.bannerstorage;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;

public class BannerstorageCreativeModerationEventsObject extends BaseModerationObject {
    @JsonProperty("creative_id")
    private final long creativeId;

    @JsonCreator
    public BannerstorageCreativeModerationEventsObject(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("creative_id") long creativeId,
            @JsonProperty("was_copied") Boolean wasCopied) {
        super(essTag, eventTime, wasCopied);
        this.creativeId = creativeId;
    }

    public Long getCreativeId() {
        return creativeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        if (!super.equals(o)) {
            return false;
        }
        BannerstorageCreativeModerationEventsObject that = (BannerstorageCreativeModerationEventsObject) o;
        return creativeId == that.creativeId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), creativeId);
    }

    @Override
    public Long getObjectId() {
        return creativeId;
    }

    @Override
    public String toString() {
        return "BannerstorageCreativeModerationEventsObject{" +
                "creativeId=" + creativeId +
                "} " + super.toString();
    }
}
