package ru.yandex.direct.ess.logicobjects.moderation.callout;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;

public class CalloutModerationEventsObject extends BaseModerationObject {

    @JsonProperty("callout_id")
    private final Long calloutId;

    public CalloutModerationEventsObject(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("was_copied") Boolean wasCopied,
            @JsonProperty("callout_id") Long calloutId) {
        super(essTag, eventTime, wasCopied);
        this.calloutId = calloutId;
    }

    public Long getCalloutId() {
        return calloutId;
    }

    @Override
    public Long getObjectId() {
        return calloutId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CalloutModerationEventsObject that = (CalloutModerationEventsObject) o;
        return Objects.equals(calloutId, that.calloutId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), calloutId);
    }

    @Override
    public String toString() {
        return "CalloutModerationEventsObject{" +
                "calloutId=" + calloutId +
                '}' + super.toString();
    }
}
