package ru.yandex.direct.ess.logicobjects.moderation.campaign;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.logicobjects.moderation.AbstractModerationEvent;

/**
 * Описывает нотификации о кампаниях, отправляемы в модерацию:
 * - Обычная нотификация о кампании (по statusModerate=Ready, есть поле campaign_id)
 * - Нотификация о копированиия кампании (полe from_campaign_id ненулевое)
 * Если кампания была скопирована в статусе Ready, то одно событие описывает две нотификации.
 */
public class CampaignModerationEvent extends AbstractModerationEvent {

    @JsonProperty("to_campaign_id")
    private final Long toCampaignId;

    @JsonProperty("to_client_id")
    private final Long toClientId;

    @JsonProperty("to_uid")
    private final Long toUid;

    @JsonProperty("from_campaign_id")
    private final Long fromCampaignId;

    @JsonProperty("campaign_id")
    private final Long campaignId;

    @JsonProperty("client_id")
    private final Long clientId;

    public CampaignModerationEvent(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("to_campaign_id") Long toCampaignId,
            @JsonProperty("to_client_id") Long toClientId,
            @JsonProperty("to_uid") Long toUid,
            @JsonProperty("from_campaign_id") Long fromCampaignId,
            @JsonProperty("campaign_id") Long campaignId,
            @JsonProperty("client_id") Long clientId) {
        super(essTag, eventTime);
        this.fromCampaignId = fromCampaignId;
        this.toCampaignId = toCampaignId;
        this.toClientId = toClientId;
        this.toUid = toUid;
        this.campaignId = campaignId;
        this.clientId = clientId;
    }

    public Long getFromCampaignId() {
        return fromCampaignId;
    }

    public Long getToCampaignId() {
        return toCampaignId;
    }

    public Long getToClientId() {
        return toClientId;
    }

    public Long getToUid() {
        return toUid;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public Long getClientId() {
        return clientId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), toCampaignId, fromCampaignId, toClientId, toUid, campaignId, clientId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CampaignModerationEvent that = (CampaignModerationEvent) o;
        return Objects.equals(toCampaignId, that.toCampaignId) &&
                Objects.equals(fromCampaignId, that.fromCampaignId) &&
                Objects.equals(toClientId, that.toClientId) &&
                Objects.equals(toUid, that.toUid) &&
                Objects.equals(campaignId, that.campaignId) &&
                Objects.equals(clientId, that.clientId);
    }

    @Override
    public String toString() {
        return "CampaignModerationEvent{" +
                "toCampaignId=" + toCampaignId +
                "fromCampaignId=" + fromCampaignId +
                "toClientId=" + toClientId +
                "toUid=" + toUid +
                "campaignId=" + campaignId +
                "clientId=" + clientId +
                '}' + super.toString();
    }
}
