package ru.yandex.direct.ess.logicobjects.moderation.campstatusmoderate;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ess.logicobjects.moderation.BaseModerationObject;

public class CampaignStatusEventsObject extends BaseModerationObject {

    @JsonProperty("campaign_id")
    private final long campaignId;

    @JsonCreator
    public CampaignStatusEventsObject(
            @JsonProperty("ess_tag") String essTag,
            @JsonProperty("event_time") Long eventTime,
            @JsonProperty("campaign_id") long campaignId,
            @JsonProperty("was_copied") Boolean wasCopied)
    {
        super(essTag, eventTime, wasCopied);
        this.campaignId = campaignId;
    }

    public long getCampaignId() {
        return campaignId;
    }

    @Override
    public Long getObjectId() {
        return campaignId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        if (!super.equals(o)) {
            return false;
        }
        CampaignStatusEventsObject that = (CampaignStatusEventsObject) o;
        return campaignId == that.campaignId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), campaignId);
    }
}
